<?php
$clientScript = Yii::app()->clientScript;
$clientScript->registerScriptFile(Yii::app()->baseUrl.'/js/lib/jquery.flot.js');
$clientScript->registerScriptFile(Yii::app()->baseUrl.'/js/lib/jquery.flot.categories.js');
$clientScript->registerScriptFile(Yii::app()->baseUrl.'/js/admin/main.js');

$clientScript->registerScript('chart', <<<CHART_SCRIPT
$(function () {
	var data = new Array();
	var dataObject = $dataJsObject;
	for(var prop in dataObject)
		data.push([prop, dataObject[prop] ]);

	//Display graph
	$.plot($("#placeholder1"), colourBars(dataObject, data), {
		grid:{
			hoverable:true
		},
		xaxis: {
			mode: "categories",
			tickLength: 0
		},
		bars: {
			show: true,
			barWidth: 0.2,
			order: 1,
		},
		legend: true,
	});

	$("#placeholder1 .flot-x-axis div").each(function(){
		var innerString = $(this).text();
		var tempArray = innerString.split(" ");
		tempArray.pop();
		innerString = tempArray.join(" ");
		$(this).text(innerString);
	});

	//tooltip function
	function showTooltip(x, y, contents, areAbsoluteXY) {
		var rootElt = 'body';

		$('<div id="tooltip2" class="tooltip">' + contents + '</div>').css( {
			position: 'fixed',
			display: 'none',
			top: y - 35,
			left: x - 5,
			'z-index': '9999',
			'color': '#fff',
			'font-size': '11px',
			opacity: 0.8
		}).prependTo(rootElt).show();
	}

	//add tooltip event
	$("#placeholder1").bind("plothover", function (event, pos, item) {
	    if (item) {
		if (previousPoint != item.datapoint) {
		    previousPoint = item.datapoint;

		    //delete de prГ©cГ©dente tooltip
		    $('.tooltip').remove();

		    var x = item.datapoint[0];

		    //All the bars concerning a same x value must display a tooltip with this value and not the shifted value
		    if(item.series.bars.order){
			for(var i=0; i < item.series.data.length; i++){
			    if(item.series.data[i][3] == item.datapoint[0])
				x = item.series.data[i][0];
			}
		    }

		    var y = item.datapoint[1];

		    showTooltip(item.pageX+5, item.pageY+5,"Szkoła: "+data[x][0]+", Punkty: " + y);

		}
	    }
	    else {
		$('.tooltip').remove();
		previousPoint = null;
	    }

	});

});
CHART_SCRIPT
, CClientScript::POS_READY);

$this->breadcrumbs = array(
	'Statystyki'
); ?>

<h1>Statystyki</h1>

<a style="margin-bottom:15px" class="buttonS bGreen" href="<?php echo $this->createUrl('toplist',array('listType'=>'class')) ?>">Toplista klas</a>
<a style="margin-bottom:15px" class="buttonS bGreen" href="<?php echo $this->createUrl('toplist',array('listType'=>'student')) ?>">Toplista uczniów</a>
<a style="margin-bottom:15px" class="buttonS bGreen" href="<?php echo $this->createUrl('toplist',array('listType'=>'company')) ?>">Toplista firm</a>

<div class="bars" id="placeholder1"></div>

<?php
	$this->widget('zii.widgets.grid.CGridView', array(
		'id'=>'parametry-gry-grid',
		'dataProvider'=>$schoolsDataProvider,
		'htmlOptions' => array('class' => 'tDefault'),
		'columns'=>array(
			array(
				'name'=>'Szkoła',
				'header'=>'Szkoła',
				'value'=>'\'<a style="width:100%; height: 100%; display: block; text-align: center;" href="\'.Yii::app()->createUrl(\'administration/main/statistics\',array(\'schoolId\'=>$data["id"])).\'"><b>\'.$data["nazwa"].\'</b></a>\'',
				'type'=>'raw'
			),
			array(
				'name'=>'punkty',
				'header'=>'Punkty',
				'value'=>'$data["punkty"]',
				'type'=>'raw'
			),
		),
	));
?>
